#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "global.h"
#include "agent.h"
#include "utils.h"
#include "namespace.h"

#define SHIFT   16

#define UPPER(a)	((((a)>>SHIFT) & 0xFFFF)-0x8000)
#define LOWER(a)	((((a)) & 0xFFFF)-0x8000)
#define BOUNDS(a,b)	(((((a)+0x8000) & 0xFFFF)<<SHIFT) | (((b)+0x8000) & 0xFFFF))

NAMESPACE agent_classes;

int add_agentclass(char * name, AGENTCLASS * ac)
{
if(agent_classes.names_free>=agent_classes.names_size+1)expand_namespace(&agent_classes);
agent_classes.data[agent_classes.names_free]=ac;
agent_classes.names[agent_classes.names_free]=strdup(name);
ac->class_handle=agent_classes.names_free;
agent_classes.names_free++;
return 0;
}


void delete_agentclass(long i)
{
long k;
AGENTCLASS *ac;
agent_classes.names_free--;
free(agent_classes.names[i]);
ac=agent_classes.data[i];
free(ac->attr_params);
free(ac);
for(k=i;k<agent_classes.names_free;i++){
	agent_classes.names[i]=agent_classes.names[i+1];
	agent_classes.data[i]=agent_classes.data[i+1];
	}
}

AGENTCLASS * get_agentclass(char *name)
{
long i;
for(i=0;i<agent_classes.names_free;i++){
	if(!strcmp(name,agent_classes.names[i]))return agent_classes.data[i];
	}
return NULL;
}



void init_agents(void)
{
init_namespace(&agent_classes);
agent_classes.add_object=(int (*)(char *,void *))add_agentclass;
agent_classes.get_object=(void * (*)(char *))get_agentclass;
}

void reset_agentclasses(void)
{
long i;
for(i=agent_classes.names_free-1;i>=0;i--)delete_agentclass(i);
}

AGENT * alloc_agent(AGENTCLASS *ac)
{
AGENT *r;

r=do_alloc(1,sizeof(AGENT));
r->attribute=do_alloc(num_attributes(),sizeof(u64));
r->class_handle=ac->class_handle;
return r;
}

AGENTCLASS * get_agentclass_from_handle(long h)
{
if(h<0)return NULL;
return (AGENTCLASS *)agent_classes.data[h];
}

long get_max_class_handle(void)
{
return agent_classes.names_free;
}

AGENT *dup_agent(AGENT *a)
{
AGENT *r;
r=do_alloc(1,sizeof(AGENT));
r->class_handle=a->class_handle;
r->attribute=do_alloc(num_attributes(),sizeof(u64));
memcpy(r->attribute,a->attribute,num_attributes()*sizeof(u64));
return r;
}

void free_agent(AGENT * a)
{
if(a==NULL)return;
free(a->attribute);
free(a);
}


AGENT * make_agent(AGENTCLASS *ac)
{
AGENT *r;
ATTRIBUTE *a;
long i;

r=alloc_agent(ac);
for(i=0;i<num_attributes();i++){
	a=get_attribute(i);
	r->attribute[i]=generate_value(a,&(ac->attr_params[i]));
	}
return r;
}

AGENTCLASS * add_new_agentclass(char *name)
{
AGENTCLASS *ac;
ATTRIBUTE *a;
long i;
ac=do_alloc(1,sizeof(AGENTCLASS));
ac->class_name=strdup(name);
ac->attr_params=do_alloc(num_attributes(),sizeof(ATTRIBUTE_PARAM));
for(i=0;i<num_attributes();i++){
	a=get_attribute(i);
	ac->attr_params[i].value=a->default_value;
	}
agent_classes.add_object(name,ac);
return ac;
}

int set_agentclass_attr_param_value(AGENTCLASS *ac, char *attr_name,ATTRIBUTE_PARAM *p)
{
long i;
i=get_attribute_index(attr_name);
if(i<0)return -1;
memcpy(&(ac->attr_params[i]),p,sizeof(ATTRIBUTE_PARAM));
return 0;
}

int get_attribute_value(AGENT *a, long attribute,u64 *result)
{
if(attribute<0)return -1;
if(attribute>num_attributes())return -1;
*result=a->attribute[attribute];
return 0;
}


void dump_classes(FILE *fout)
{
long i,k;
AGENTCLASS *ac;
ATTRIBUTE *a;
for(i=0;i<agent_classes.names_free;i++){
	fprintf(fout,"agentclass \"%s\"\n",agent_classes.names[i]);
	ac=(AGENTCLASS *)agent_classes.data[i];
	if(ac!=NULL)for(k=0;k<num_attributes();k++){
		a=get_attribute(k);
		dump_param(fout,a,&(ac->attr_params[k]));
		}
	fprintf(fout,"end\n");
	}
}

void dump_agent(FILE *fout, AGENT *a)
{
AGENTCLASS *ac;
int i;
if(a==NULL){
	fprintf(fout,"null");
	return;
	}
ac=get_agentclass_from_handle(a->class_handle);
if(ac==NULL){
	fprintf(fout,"null");
	return;
	}
fprintf(fout,"\"%s\"",ac->class_name);
for(i=0;i<num_attributes();i++){
	fprintf(fout," %lld",a->attribute[i]);
	}

}
